import { world, system, EntityInventoryComponent, ItemStack, ItemLockMode, Player } from "@minecraft/server";
import { ActionFormData, MessageFormData, ModalFormData } from "@minecraft/server-ui";
import { Human, Student, Teacher } from "./Humans";
import { School } from "./School";
import { SchoolClass } from "./Classes";

/**
 * Loads a player's Human data upon joining the world
 */
export function registration(){
    world.afterEvents.playerSpawn.subscribe((event)=>{
        if(event.player.hasTag('registered')==false || !event.player.getDynamicProperty("jo:humanData")){
            let time = Date(); let {player, initialSpawn} = event; let human = new Human(player.name, player.name, time, initialId());
            human.registerHuman();
            player.setDynamicProperty("jo:humanId", human.identifier); player.setDynamicProperty("jo:humanData", human.getSaveString());
            console.warn(human.getSaveString());
            let l = world.getDynamicProperty("jo:humanIds"); l++; world.setDynamicProperty("jo:humanIds", l)
            let inv = player.getComponent("minecraft:inventory"); let item = new ItemStack("jo:menu", 1); item.nameTag = "§r§fMenu"; item.keepOnDeath = true; item.lockMode = ItemLockMode.inventory; item.setLore(["§eInteract to see options!§r"]); inv.container.setItem(8, item);
            player.addTag("registered"); world.sendMessage("A new Human has entered the school: "+player.name);
        }else if(event.player.hasTag('registered')==true){
            let human;
            switch(event.player.getDynamicProperty("jo:humanType")){
                case 0: let data0 = JSON.parse(event.player.getDynamicProperty("jo:humanData")); human = new Human(data0.name, data0.familyName, data0.birthdate, event.player.getDynamicProperty("jo:humanId")); human.loadSaveString(event.player.getDynamicProperty("jo:humanData")); break;
                case 1: let data1 = JSON.parse(event.player.getDynamicProperty("jo:teacherData")); human = new Teacher(data1.name, data1.familyName, data1.birthdate, event.player.getDynamicProperty("jo:humanId")); human.loadDataFromTeacher(event.player.getDynamicProperty("jo:teacherData")); break;
                case 2: let data2 = JSON.parse(event.player.getDynamicProperty("jo:studentData")); human = new Student(data2.name, data2.familyName, data2.birthdate, event.player.getDynamicProperty("jo:humanId")); human.loadDataFromStudent(event.player.getDynamicProperty("jo:studentData")); break;
                default: break;
            };
            human.registerHuman(); world.sendMessage("Welcome Back, "+human.name+" "+human.familyName+"!");
            system.runTimeout(()=>{School.updateOld();}, 20);
        };
    })
};
/**
 * Return the next number Id unregistered
 */
export function initialId(){
    let l;
    if(!world.getDynamicProperty("jo:humanIds")){l=0;world.setDynamicProperty("jo:humanIds", l);}else {l=world.getDynamicProperty("jo:humanIds");world.setDynamicProperty("jo:humanIds", l);}
    console.warn("l is: "+l);
    return l;
}

/**
 * Shows the school menus to the selected player.
 * @param {Player} player The player that opened the school menu book.
 */
export function schoolMenus(player){
    let schoolMenu = new ActionFormData(); schoolMenu.title("School-Menu"); schoolMenu.body("Select something or go away."); schoolMenu.button("Edit personal stats!", "textures/ui/Feedback.png"); schoolMenu.button("Check stats!", "textures/icons/skin_default");
    
    let genderOptions = ["male", "female", "intersex", "none", "nonbinary", "divers"];
    let statsWindow = new MessageFormData(); statsWindow.title("Your stats"); let sp = Human.lookForHuman(player.getDynamicProperty("jo:humanId")); let message; if(sp.type==0){message = sp.getSaveString()}else if(sp.type ==1){message= sp.getSaveTeacherString()}else if(sp.type==2){message= sp.getSaveStudentString()}; let m = ""; for(let z = 0; z < message.split(",").length; z++){m+=message.split(",")[z]+"\n"}; statsWindow.body(m); statsWindow.button1("Ok"); statsWindow.button2("Close");
        let nameStatMenu = new ModalFormData(); nameStatMenu.title("Change names"); nameStatMenu.textField("Your name", "name"); nameStatMenu.textField("Your family name", "family name"); let genderStatMenu = new ModalFormData(); genderStatMenu.title("Change gender"); genderStatMenu.dropdown("Select system registrated genders", genderOptions, 3); genderStatMenu.textField("Use other", "Write your gender here!", "A gender not listed above");
        let lovesStatMenu = new ModalFormData(); lovesStatMenu.title("Edit loves"); lovesStatMenu.toggle("Remove|Add a loved", true); lovesStatMenu.textField("The name of the human to add/remove", "name (not with family name)"); let hatesStatMenu = new ModalFormData(); hatesStatMenu.title("Edit hates"); hatesStatMenu.toggle("Remove|add a hated one", true); hatesStatMenu.textField("The name of the person to add/remove", "name (without family name)"); 
    let statMenus = [nameStatMenu, genderStatMenu, lovesStatMenu, hatesStatMenu];
    let statButtons = ["Change names", "Change gender", "Edit loved ones", "Edit hated ones"]; 
    let statMainMenu = new ActionFormData(); statMainMenu.title("Change personal stats"); statMainMenu.body("Select a stat to change it's value. You can only edit stats which aren't set by the system!"); for(let stat = 0; stat < statMenus.length; stat++){statMainMenu.button(statButtons[stat])};    
    /**
     * @type {Array<ActionFormData>}
     */
    let buttons1 = [statMainMenu, statsWindow];
    let playerHuman = Human.lookForHuman(player.getDynamicProperty("jo:humanId"));

    schoolMenu.show(player).then((res_)=>{
        if(res_.canceled){
            return;
        }else {
            switch (res_.selection){
                case 0: buttons1[0].show(player).then((resp)=>{
                    if(resp.canceled){return;}else {
                        switch (resp.selection){
                            case 0: nameStatMenu.show(player).then((res)=>{if(res.canceled){return;}else {playerHuman.name = res.formValues[0]; playerHuman.familyName = res.formValues[1]}}); break;
                            case 1: genderStatMenu.show(player).then((res)=>{if(res.canceled){return;}else {if(res.formValues[1]!=""&&res.formValues[1]!="A gender not listed above"){playerHuman.gender=res.formValues[1]}else {playerHuman.gender = genderOptions[res.formValues[0]]}}}); break;
                            case 2: lovesStatMenu.show(player).then((res)=>{if(res.canceled){return;}else {if(res.formValues[0]==true){if(world.getPlayers({name: res.formValues[1]}).length>=1){if(!playerHuman.loves.includes(world.getPlayers({name: res.formValues[1]})[0].getDynamicProperty("jo:humanId")))playerHuman.loves.push(world.getPlayers({name: res.formValues[1]})[0].getDynamicProperty("jo:humanId"))}else {player.dimension.runCommandAsync("tell "+player.name+" This player is not online!")}}else if(res.formValues[0]==false){if(world.getPlayers({name: res.formValues[1]}).length>=1){for(let i = 0; i < playerHuman.loves.length; i++){if(playerHuman.loves[i]==world.getPlayers({name: res.formValues[1]})[0].getDynamicProperty("jo:humanId")){playerHuman.loves.splice(i, 1)}}}else {player.dimension.runCommandAsync("tell "+player.name+" This player is not online!")}}}}); break;
                            case 3: hatesStatMenu.show(player).then((res)=>{if(res.canceled){return;}else {if(res.formValues[0]==true){if(world.getPlayers({name: res.formValues[1]}).length>=1){if(!playerHuman.hates.includes(world.getPlayers({name: res.formValues[1]})[0].getDynamicProperty("jo:humanId")))playerHuman.hates.push(world.getPlayers({name: res.formValues[1]})[0].getDynamicProperty("jo:humanId"))}else {player.dimension.runCommandAsync("tell "+player.name+" This player is not online!")}}else if(res.formValues[0]==false){if(world.getPlayers({name: res.formValues[1]}).length>=1){for(let i = 0; i < playerHuman.hates.length; i++){if(playerHuman.hates[i]==world.getPlayers({name: res.formValues[1]})[0].getDynamicProperty("jo:humanId")){playerHuman.hates.splice(i, 1)}}}else {player.dimension.runCommandAsync("tell "+player.name+" This player is not online!")}}}}); break;
                            default: return;
                        };
                    };
                }); break;
                case 1: buttons1[1].show(player).then((resp)=>{}); break;
                default: break;
            }
        }
    })
}

/**
 * Saves the any player's human data before leaving the world
 */
export function saveHumanData(){
    world.beforeEvents.playerLeave.subscribe((event)=>{
        switch (Human.lookForHuman(event.player.getDynamicProperty("jo:humanId")).type){
            case 0: event.player.setDynamicProperty("jo:humanData", Human.lookForHuman(event.player.getDynamicProperty("jo:humanId")).getSaveString()); event.player.setDynamicProperty("jo:humanType", 0); break;
            case 1: event.player.setDynamicProperty("jo:teacherData", Human.lookForHuman(event.player.getDynamicProperty("jo:humanId")).getSaveTeacherString());event.player.setDynamicProperty("jo:humanType", 1);break;
            case 2: event.player.setDynamicProperty("jo:studentData", Human.lookForHuman(event.player.getDynamicProperty("jo:humanId")).getSaveStudentString());event.player.setDynamicProperty("jo:humanType", 2);break;
            default: break;    
        }
    }) 
};
/**
 * Saves the School data into the World Dynamic Property
 */
export function saveSchoolData(){
    world.beforeEvents.playerLeave.subscribe((event)=>{
        if(world.getAllPlayers().length==1){
            let schoolNames = [];
            let schoolData = [];
            for(let sc = 0; sc<School.schools.length; sc++){
                let schoolPersonal = [];
                let schoolStudentIds = [];
                let schoolClasses = [];
                for(let st = 0; st<School.schools[sc].students.length; st++){
                    schoolStudentIds.push(School.schools[sc].students[st].identifier);
                };
                for(let scl = 0; scl < School.schools[sc].classes.length; scl++){
                    let clas = School.schools[sc].classes[scl];
                    let clasStudents = [];
                    for(let cs = 0; cs<clas.students.length; cs++){
                        clasStudents.push(clas.students[cs].identifier);
                    };
                    schoolClasses.push({letter: clas.letter, grade:clas.grade, sid: clas.schoolClassIdentifier, students:clasStudents});
                };
                for(let sp = 0; sp<School.schools[sc].personal.length; sp++){
                    schoolPersonal.push(School.schools[sc].personal[sp].identifier);
                };
                for(let oP = 0; oP<School.schools[sc].oldPersonal.length; oP++){
                    schoolPersonal.push(School.schools[sc].oldPersonal[oP]);
                };
                for(let os = 0; os< School.schools[sc].oldStudents.length; os++){
                    schoolStudentIds.push(School.schools[sc].oldStudents[os])
                };
                schoolNames.push(School.schools[sc].name);
                schoolData.push({personal: schoolPersonal, students:schoolStudentIds, classes: schoolClasses, perfil: School.schools[sc].perfil});
            };
            console.warn(JSON.stringify({names: schoolNames, data:schoolData}))
            world.setDynamicProperty("jo:schools", JSON.stringify({names: schoolNames, data:schoolData}));
        }else {return;}
    });
};
/**
 * Loads the School data from the World Dynamic Property after loading into the world
 */
export function loadSchools(){
    let sd = JSON.parse(world.getDynamicProperty("jo:schools"));
    let urs = [];
    for(let sn = 0; sn <sd.names.length; sn++){
        let school = new School(sd.names[sn], sd.data[sn].perfil);
        for(let clas = 0; clas<sd.data[sn].classes.length; clas++){
            let clasS = new SchoolClass(sd.data[sn].classes[clas].grade, sd.data[sn].classes[clas].letter, sd.data[sn].classes[clas].sid);
            clasS.oldStudents.push(sd.data[sn].classes[clas].students);
            school.registerClass(clasS);
        };
        for(let p = 0; p< sd.data[sn].personal.length; p++){
            school.oldPersonal.push(sd.data[sn].personal[p]);
        };
        urs.push(school);
        console.warn("Old School Data loaded: name: "+sd.names[sn]);
    };
    for(let s = 0; s<urs.length; s++){
        urs[s].registerSchool();
        console.warn("School register: "+School.schools.length);
    };
};
